/*! X-editable - v1.5.3 
* In-place editing with Twitter Bootstrap, jQuery UI or pure jQuery
* http://github.com/vitalets/x-editable
* Copyright (c) 2018 Vitaliy Potapov; Licensed MIT */
!function($){"use strict";var EditableForm=function(div,options){this.options=$.extend({},$.fn.editableform.defaults,options),this.$div=$(div),this.options.scope||(this.options.scope=this)};EditableForm.prototype={constructor:EditableForm,initInput:function(){this.input=this.options.input,this.value=this.input.str2value(this.options.value),this.input.prerender()},initTemplate:function(){this.$form=$($.fn.editableform.template)},initButtons:function(){var $btn=this.$form.find(".editable-buttons");$btn.append($.fn.editableform.buttons),"bottom"===this.options.showbuttons&&$btn.addClass("editable-buttons-bottom")},render:function(){this.$loading=$($.fn.editableform.loading),this.$div.empty().append(this.$loading),this.initTemplate(),this.options.showbuttons?this.initButtons():this.$form.find(".editable-buttons").remove(),this.showLoading(),this.isSaving=!1,this.$div.triggerHandler("rendering"),this.initInput(),this.$form.find("div.editable-input").append(this.input.$tpl),this.$div.append(this.$form),$.when(this.input.render()).then($.proxy((function(){if(this.options.showbuttons||this.input.autosubmit(),this.$form.find(".editable-cancel").click($.proxy(this.cancel,this)),this.input.error)this.error(this.input.error),this.$form.find(".editable-submit").attr("disabled",!0),this.input.$input.attr("disabled",!0),this.$form.submit((function(e){e.preventDefault()}));else{this.error(!1),this.input.$input.removeAttr("disabled"),this.$form.find(".editable-submit").removeAttr("disabled");var value=null===this.value||void 0===this.value||""===this.value?this.options.defaultValue:this.value;this.input.value2input(value),this.$form.submit($.proxy(this.submit,this))}this.$div.triggerHandler("rendered"),this.showForm(),this.input.postrender&&this.input.postrender()}),this))},cancel:function(){this.$div.triggerHandler("cancel")},showLoading:function(){var w,h;this.$form?(w=this.$form.outerWidth(),h=this.$form.outerHeight(),w&&this.$loading.width(w),h&&this.$loading.height(h),this.$form.hide()):(w=this.$loading.parent().width())&&this.$loading.width(w),this.$loading.show()},showForm:function(activate){this.$loading.hide(),this.$form.show(),!1!==activate&&this.input.activate(),this.$div.triggerHandler("show")},error:function(msg){var $group=this.$form.find(".control-group"),$block=this.$form.find(".editable-error-block"),lines;if(!1===msg)$group.removeClass($.fn.editableform.errorGroupClass),$block.removeClass($.fn.editableform.errorBlockClass).empty().hide();else{if(msg){lines=(""+msg).split("\n");for(var i=0;i<lines.length;i++)lines[i]=$("<div>").text(lines[i]).html();msg=lines.join("<br>")}$group.addClass($.fn.editableform.errorGroupClass),$block.addClass($.fn.editableform.errorBlockClass).html(msg).show()}},submit:function(e){e.stopPropagation(),e.preventDefault();var newValue=this.input.input2value(),error=this.validate(newValue);if("object"===$.type(error)&&void 0!==error.newValue){if(newValue=error.newValue,this.input.value2input(newValue),"string"==typeof error.msg)return this.error(error.msg),void this.showForm()}else if(error)return this.error(error),void this.showForm();if(this.options.savenochange||this.input.value2str(newValue)!==this.input.value2str(this.value)){var submitValue=this.input.value2submit(newValue);this.isSaving=!0,$.when(this.save(submitValue)).done($.proxy((function(response){this.isSaving=!1;var res="function"==typeof this.options.success?this.options.success.call(this.options.scope,response,newValue):null;return!1===res?(this.error(!1),void this.showForm(!1)):"string"==typeof res?(this.error(res),void this.showForm()):(res&&"object"==typeof res&&res.hasOwnProperty("newValue")&&(newValue=res.newValue),this.error(!1),this.value=newValue,void this.$div.triggerHandler("save",{newValue:newValue,submitValue:submitValue,response:response}))}),this)).fail($.proxy((function(xhr){var msg;this.isSaving=!1,msg="function"==typeof this.options.error?this.options.error.call(this.options.scope,xhr,newValue):"string"==typeof xhr?xhr:xhr.responseText||xhr.statusText||"Unknown error!",this.error(msg),this.showForm()}),this))}else this.$div.triggerHandler("nochange")},save:function(submitValue){this.options.pk=$.fn.editableutils.tryParseJson(this.options.pk,!0);var pk="function"==typeof this.options.pk?this.options.pk.call(this.options.scope):this.options.pk,send,params;if(!!("function"==typeof this.options.url||this.options.url&&("always"===this.options.send||"auto"===this.options.send&&null!=pk)))return this.showLoading(),params={name:this.options.name||"",value:submitValue,pk:pk},"function"==typeof this.options.params?params=this.options.params.call(this.options.scope,params):(this.options.params=$.fn.editableutils.tryParseJson(this.options.params,!0),$.extend(params,this.options.params)),"function"==typeof this.options.url?this.options.url.call(this.options.scope,params):$.ajax($.extend({url:this.options.url,data:params,type:"POST"},this.options.ajaxOptions))},validate:function(value){if(void 0===value&&(value=this.value),"function"==typeof this.options.validate)return this.options.validate.call(this.options.scope,value)},option:function(key,value){key in this.options&&(this.options[key]=value),"value"===key&&this.setValue(value)},setValue:function(value,convertStr){this.value=convertStr?this.input.str2value(value):value,this.$form&&this.$form.is(":visible")&&this.input.value2input(this.value)}},$.fn.editableform=function(option){var args=arguments;return this.each((function(){var $this=$(this),data=$this.data("editableform"),options="object"==typeof option&&option;data||$this.data("editableform",data=new EditableForm(this,options)),"string"==typeof option&&data[option].apply(data,Array.prototype.slice.call(args,1))}))},$.fn.editableform.Constructor=EditableForm,$.fn.editableform.defaults={type:"text",url:null,params:null,name:null,pk:null,value:null,defaultValue:null,send:"auto",validate:null,success:null,error:null,ajaxOptions:null,showbuttons:!0,scope:null,savenochange:!1},$.fn.editableform.template='<form class="form-inline editableform"><div class="control-group"><div><div class="editable-input"></div><div class="editable-buttons"></div></div><div class="editable-error-block"></div></div></form>',$.fn.editableform.loading='<div class="editableform-loading"></div>',$.fn.editableform.buttons='<button type="submit" class="editable-submit">ok</button><button type="button" class="editable-cancel">cancel</button>',$.fn.editableform.errorGroupClass=null,$.fn.editableform.errorBlockClass="editable-error",$.fn.editableform.engine="jquery"}(window.jQuery),function($){"use strict";$.fn.editableutils={inherit:function(Child,Parent){var F=function(){};F.prototype=Parent.prototype,Child.prototype=new F,Child.prototype.constructor=Child,Child.superclass=Parent.prototype},setCursorPosition:function(elem,pos){if(elem.setSelectionRange)try{elem.setSelectionRange(pos,pos)}catch(e){}else if(elem.createTextRange){var range=elem.createTextRange();range.collapse(!0),range.moveEnd("character",pos),range.moveStart("character",pos),range.select()}},tryParseJson:function(s,safe){if("string"==typeof s&&s.length&&s.match(/^[\{\[].*[\}\]]$/))if(safe)try{s=new Function("return "+s)()}catch(e){}finally{return s}else s=new Function("return "+s)();return s},sliceObj:function(obj,keys,caseSensitive){var key,keyLower,newObj={};if(!$.isArray(keys)||!keys.length)return newObj;for(var i=0;i<keys.length;i++)key=keys[i],obj.hasOwnProperty(key)&&(newObj[key]=obj[key]),!0!==caseSensitive&&(keyLower=key.toLowerCase(),obj.hasOwnProperty(keyLower)&&(newObj[key]=obj[keyLower]));return newObj},getConfigData:function($element){var data={};return $.each($element[0].dataset,(function(k,v){("object"!=typeof v||v&&"object"==typeof v&&(v.constructor===Object||v.constructor===Array))&&(data[k]=v)})),data},objectKeys:function(o){if(Object.keys)return Object.keys(o);if(o!==Object(o))throw new TypeError("Object.keys called on a non-object");var k=[],p;for(p in o)Object.prototype.hasOwnProperty.call(o,p)&&k.push(p);return k},escape:function(str){return $("<div>").text(str).html()},itemsByValue:function(value,sourceData,valueProp){if(!sourceData||null===value)return[];if("function"!=typeof valueProp){var idKey=valueProp||"value";valueProp=function(e){return e[idKey]}}var isValArray=$.isArray(value),result=[],that=this;return $.each(sourceData,(function(i,o){if(o.children)result=result.concat(that.itemsByValue(value,o.children,valueProp));else if(isValArray)$.grep(value,(function(v){return v==(o&&"object"==typeof o?valueProp(o):o)})).length&&result.push(o);else{var itemValue=o&&"object"==typeof o?valueProp(o):o;value==itemValue&&result.push(o)}})),result},createInput:function(options){var TypeConstructor,typeOptions,input,type=options.type;return"date"===type&&("inline"===options.mode?$.fn.editabletypes.datefield?type="datefield":$.fn.editabletypes.dateuifield&&(type="dateuifield"):$.fn.editabletypes.date?type="date":$.fn.editabletypes.dateui&&(type="dateui"),"date"!==type||$.fn.editabletypes.date||(type="combodate")),"datetime"===type&&"inline"===options.mode&&(type="datetimefield"),"wysihtml5"!==type||$.fn.editabletypes[type]||(type="textarea"),"function"==typeof $.fn.editabletypes[type]?input=new(TypeConstructor=$.fn.editabletypes[type])(typeOptions=this.sliceObj(options,this.objectKeys(TypeConstructor.defaults))):($.error("Unknown type: "+type),!1)},supportsTransitions:function(){var b,s=(document.body||document.documentElement).style,p="transition",v=["Moz","Webkit","Khtml","O","ms"];if("string"==typeof s[p])return!0;p=p.charAt(0).toUpperCase()+p.substr(1);for(var i=0;i<v.length;i++)if("string"==typeof s[v[i]+p])return!0;return!1}}}(window.jQuery),function($){"use strict";var Popup=function(element,options){this.init(element,options)},Inline=function(element,options){this.init(element,options)};Popup.prototype={containerName:null,containerDataName:null,innerCss:null,containerClass:"editable-container editable-popup",defaults:{},init:function(element,options){this.$element=$(element),this.options=$.extend({},$.fn.editableContainer.defaults,options),this.splitOptions(),this.formOptions.scope=this.$element[0],this.initContainer(),this.delayedHide=!1,this.$element.on("destroyed",$.proxy((function(){this.destroy()}),this)),$(document).data("editable-handlers-attached")||($(document).on("keyup.editable",(function(e){27===e.which&&$(".editable-open").editableContainer("hide","cancel")})),$(document).on("click.editable",(function(e){var $target=$(e.target),i,exclude_classes=[".editable-container",".ui-datepicker-header",".datepicker",".modal-backdrop",".bootstrap-wysihtml5-insert-image-modal",".bootstrap-wysihtml5-insert-link-modal"];if(!$(".select2-drop-mask").is(":visible")&&$.contains(document.documentElement,e.target)&&!$target.is(document)){for(i=0;i<exclude_classes.length;i++)if($target.is(exclude_classes[i])||$target.parents(exclude_classes[i]).length)return;Popup.prototype.closeOthers(e.target)}})),$(document).data("editable-handlers-attached",!0))},splitOptions:function(){if(this.containerOptions={},this.formOptions={},!$.fn[this.containerName])throw new Error(this.containerName+" not found. Have you included corresponding js file?");for(var k in this.options)k in this.defaults?this.containerOptions[k]=this.options[k]:this.formOptions[k]=this.options[k]},tip:function(){return this.container()?this.container().$tip:null},container:function(){var container;return this.containerDataName&&(container=this.$element.data(this.containerDataName))?container:container=this.$element.data(this.containerName)},call:function(){this.$element[this.containerName].apply(this.$element,arguments)},initContainer:function(){this.call(this.containerOptions)},renderForm:function(){this.$form.editableform(this.formOptions).on({save:$.proxy(this.save,this),nochange:$.proxy((function(){this.hide("nochange")}),this),cancel:$.proxy((function(){this.hide("cancel")}),this),show:$.proxy((function(){this.delayedHide?(this.hide(this.delayedHide.reason),this.delayedHide=!1):this.setPosition()}),this),rendering:$.proxy(this.setPosition,this),resize:$.proxy(this.setPosition,this),rendered:$.proxy((function(){this.$element.triggerHandler("shown",$(this.options.scope).data("editable"))}),this)}).editableform("render")},show:function(closeAll){this.$element.addClass("editable-open"),!1!==closeAll&&this.closeOthers(this.$element[0]),this.innerShow(),this.tip().addClass(this.containerClass),this.$form&&this.$form.remove(),this.$form=$("<div>"),this.tip().is(this.innerCss)?this.tip().append(this.$form):this.tip().find(this.innerCss).append(this.$form),this.renderForm()},hide:function(reason){this.tip()&&this.tip().is(":visible")&&this.$element.hasClass("editable-open")&&(this.$form.data("editableform").isSaving?this.delayedHide={reason:reason}:(this.delayedHide=!1,this.$element.removeClass("editable-open"),this.innerHide(),this.$element.triggerHandler("hidden",reason||"manual")))},innerShow:function(){},innerHide:function(){},toggle:function(closeAll){this.container()&&this.tip()&&this.tip().is(":visible")?this.hide():this.show(closeAll)},setPosition:function(){},save:function(e,params){this.$element.triggerHandler("save",params),this.hide("save")},option:function(key,value){this.options[key]=value,key in this.containerOptions?(this.containerOptions[key]=value,this.setContainerOption(key,value)):(this.formOptions[key]=value,this.$form&&this.$form.editableform("option",key,value))},setContainerOption:function(key,value){this.call("option",key,value)},destroy:function(){this.hide(),this.innerDestroy(),this.$element.off("destroyed"),this.$element.removeData("editableContainer")},innerDestroy:function(){},closeOthers:function(element){$(".editable-open").each((function(i,el){if(el!==element&&!$(el).find(element).length){var $el=$(el),ec=$el.data("editableContainer");ec&&("cancel"===ec.options.onblur?$el.data("editableContainer").hide("onblur"):"submit"===ec.options.onblur&&$el.data("editableContainer").tip().find("form").submit())}}))},activate:function(){this.tip&&this.tip().is(":visible")&&this.$form&&this.$form.data("editableform").input.activate()}},$.fn.editableContainer=function(option){var args=arguments;return this.each((function(){var $this=$(this),dataKey="editableContainer",data=$this.data(dataKey),options="object"==typeof option&&option,Constructor="inline"===options.mode?Inline:Popup;data||$this.data(dataKey,data=new Constructor(this,options)),"string"==typeof option&&data[option].apply(data,Array.prototype.slice.call(args,1))}))},$.fn.editableContainer.Popup=Popup,$.fn.editableContainer.Inline=Inline,$.fn.editableContainer.defaults={value:null,placement:"top",autohide:!0,onblur:"cancel",anim:!1,mode:"popup"},jQuery.event.special.destroyed={remove:function(o){o.handler&&o.handler()}}}(window.jQuery),function($){"use strict";$.extend($.fn.editableContainer.Inline.prototype,$.fn.editableContainer.Popup.prototype,{containerName:"editableform",innerCss:".editable-inline",containerClass:"editable-container editable-inline",initContainer:function(){this.$tip=$("<span></span>"),this.options.anim||(this.options.anim=0)},splitOptions:function(){this.containerOptions={},this.formOptions=this.options},tip:function(){return this.$tip},innerShow:function(){this.$element.hide(),this.tip().insertAfter(this.$element).show()},innerHide:function(){this.$tip.hide(this.options.anim,$.proxy((function(){this.$element.show(),this.innerDestroy()}),this))},innerDestroy:function(){this.tip()&&this.tip().empty().remove()}})}(window.jQuery),function($){"use strict";var Editable=function(element,options){this.$element=$(element),this.options=$.extend({},$.fn.editable.defaults,options,$.fn.editableutils.getConfigData(this.$element)),this.options.selector?this.initLive():this.init(),this.options.highlight&&!$.fn.editableutils.supportsTransitions()&&(this.options.highlight=!1)};Editable.prototype={constructor:Editable,init:function(){var isValueByText=!1,doAutotext,finalize;if(this.options.name=this.options.name||this.$element.attr("id"),this.options.scope=this.$element[0],this.input=$.fn.editableutils.createInput(this.options),this.input){switch(void 0===this.options.value||null===this.options.value?(this.value=this.input.html2value($.trim(this.$element.html())),isValueByText=!0):(this.options.value=$.fn.editableutils.tryParseJson(this.options.value,!0),"string"==typeof this.options.value?this.value=this.input.str2value(this.options.value):this.value=this.options.value),this.$element.addClass("editable"),"textarea"===this.input.type&&this.$element.addClass("editable-pre-wrapped"),"manual"!==this.options.toggle?(this.$element.addClass("editable-click"),this.$element.on(this.options.toggle+".editable",$.proxy((function(e){if(this.options.disabled||e.preventDefault(),"mouseenter"===this.options.toggle)this.show();else{var closeAll="click"!==this.options.toggle;this.toggle(closeAll)}}),this))):this.$element.attr("tabindex",-1),"function"==typeof this.options.display&&(this.options.autotext="always"),this.options.autotext){case"always":doAutotext=!0;break;case"auto":doAutotext=!$.trim(this.$element.text()).length&&null!==this.value&&void 0!==this.value&&!isValueByText;break;default:doAutotext=!1}$.when(!doAutotext||this.render()).then($.proxy((function(){this.options.disabled?this.disable():this.enable(),this.$element.triggerHandler("init",this)}),this))}},initLive:function(){var selector=this.options.selector;this.options.selector=!1,this.options.autotext="never",this.$element.on(this.options.toggle+".editable",selector,$.proxy((function(e){var $target=$(e.target).closest(selector);$target.data("editable")||($target.hasClass(this.options.emptyclass)&&$target.empty(),$target.editable(this.options).trigger(e))}),this))},render:function(response){if(!1!==this.options.display)return this.input.value2htmlFinal?this.input.value2html(this.value,this.$element[0],this.options.display,response):"function"==typeof this.options.display?this.options.display.call(this.$element[0],this.value,response):this.input.value2html(this.value,this.$element[0])},enable:function(){this.options.disabled=!1,this.$element.removeClass("editable-disabled"),this.handleEmpty(this.isEmpty),"manual"!==this.options.toggle&&"-1"===this.$element.attr("tabindex")&&this.$element.removeAttr("tabindex")},disable:function(){this.options.disabled=!0,this.hide(),this.$element.addClass("editable-disabled"),this.handleEmpty(this.isEmpty),this.$element.attr("tabindex",-1)},toggleDisabled:function(){this.options.disabled?this.enable():this.disable()},option:function(key,value){if(key&&"object"==typeof key)$.each(key,$.proxy((function(k,v){this.option($.trim(k),v)}),this));else{if(this.options[key]=value,"disabled"===key)return value?this.disable():this.enable();"value"===key&&this.setValue(value),this.container&&this.container.option(key,value),this.input.option&&this.input.option(key,value)}},handleEmpty:function(isEmpty){!1!==this.options.display&&(void 0!==isEmpty?this.isEmpty=isEmpty:"function"==typeof this.input.isEmpty?this.isEmpty=this.input.isEmpty(this.$element):this.isEmpty=""===$.trim(this.$element.html()),this.options.disabled?this.isEmpty&&(this.$element.empty(),this.options.emptyclass&&this.$element.removeClass(this.options.emptyclass)):this.isEmpty?(this.$element.html(this.options.emptytext),this.options.emptyclass&&this.$element.addClass(this.options.emptyclass)):this.options.emptyclass&&this.$element.removeClass(this.options.emptyclass))},show:function(closeAll){if(!this.options.disabled){if(this.container){if(this.container.tip().is(":visible"))return}else{var containerOptions=$.extend({},this.options,{value:this.value,input:this.input});this.$element.editableContainer(containerOptions),this.$element.on("save.internal",$.proxy(this.save,this)),this.container=this.$element.data("editableContainer")}this.container.show(closeAll)}},hide:function(){this.container&&this.container.hide()},toggle:function(closeAll){this.container&&this.container.tip().is(":visible")?this.hide():this.show(closeAll)},save:function(e,params){if(this.options.unsavedclass){var sent=!1;(sent=(sent=(sent=(sent=sent||"function"==typeof this.options.url)||!1===this.options.display)||void 0!==params.response)||this.options.savenochange&&this.input.value2str(this.value)!==this.input.value2str(params.newValue))?this.$element.removeClass(this.options.unsavedclass):this.$element.addClass(this.options.unsavedclass)}if(this.options.highlight){var $e=this.$element,bgColor=$e.css("background-color");$e.css("background-color",this.options.highlight),setTimeout((function(){"transparent"===bgColor&&(bgColor=""),$e.css("background-color",bgColor),$e.addClass("editable-bg-transition"),setTimeout((function(){$e.removeClass("editable-bg-transition")}),1700)}),10)}this.setValue(params.newValue,!1,params.response)},validate:function(){if("function"==typeof this.options.validate)return this.options.validate.call(this,this.value)},setValue:function(value,convertStr,response){this.value=convertStr?this.input.str2value(value):value,this.container&&this.container.option("value",this.value),$.when(this.render(response)).then($.proxy((function(){this.handleEmpty()}),this))},activate:function(){this.container&&this.container.activate()},destroy:function(){this.disable(),this.container&&this.container.destroy(),this.input.destroy(),"manual"!==this.options.toggle&&(this.$element.removeClass("editable-click"),this.$element.off(this.options.toggle+".editable")),this.$element.off("save.internal"),this.$element.removeClass("editable editable-open editable-disabled"),this.$element.removeData("editable")}},$.fn.editable=function(option){var result={},args=arguments,datakey="editable";switch(option){case"validate":return this.each((function(){var $this,data=$(this).data(datakey),error;data&&(error=data.validate())&&(result[data.options.name]=error)})),result;case"getValue":return 2===arguments.length&&!0===arguments[1]?result=this.eq(0).data(datakey).value:this.each((function(){var $this,data=$(this).data(datakey);data&&void 0!==data.value&&null!==data.value&&(result[data.options.name]=data.input.value2submit(data.value))})),result;case"submit":var config=arguments[1]||{},$elems=this,errors=this.editable("validate");if($.isEmptyObject(errors)){var ajaxOptions={};if(1===$elems.length){var editable=$elems.data("editable"),params={name:editable.options.name||"",value:editable.input.value2submit(editable.value),pk:"function"==typeof editable.options.pk?editable.options.pk.call(editable.options.scope):editable.options.pk};"function"==typeof editable.options.params?params=editable.options.params.call(editable.options.scope,params):(editable.options.params=$.fn.editableutils.tryParseJson(editable.options.params,!0),$.extend(params,editable.options.params)),ajaxOptions={url:editable.options.url,data:params,type:"POST"},config.success=config.success||editable.options.success,config.error=config.error||editable.options.error}else{var values=this.editable("getValue");ajaxOptions={url:config.url,data:values,type:"POST"}}ajaxOptions.success="function"==typeof config.success?function(response){config.success.call($elems,response,config)}:$.noop,ajaxOptions.error="function"==typeof config.error?function(){config.error.apply($elems,arguments)}:$.noop,config.ajaxOptions&&$.extend(ajaxOptions,config.ajaxOptions),config.data&&$.extend(ajaxOptions.data,config.data),$.ajax(ajaxOptions)}else"function"==typeof config.error&&config.error.call($elems,errors);return this}return this.each((function(){var $this=$(this),data=$this.data(datakey),options="object"==typeof option&&option;options&&options.selector?data=new Editable(this,options):(data||$this.data(datakey,data=new Editable(this,options)),"string"==typeof option&&data[option].apply(data,Array.prototype.slice.call(args,1)))}))},$.fn.editable.defaults={type:"text",disabled:!1,toggle:"click",emptytext:"Empty",autotext:"auto",value:null,display:null,emptyclass:"editable-empty",unsavedclass:"editable-unsaved",selector:null,highlight:"#FFFF80"}}(window.jQuery),function($){"use strict";$.fn.editabletypes={};var AbstractInput=function(){};AbstractInput.prototype={init:function(type,options,defaults){this.type=type,this.options=$.extend({},defaults,options)},prerender:function(){this.$tpl=$(this.options.tpl),this.$input=this.$tpl,this.$clear=null,this.error=null},render:function(){},value2html:function(value,element){$(element)[this.options.escape?"text":"html"]($.trim(value))},html2value:function(html){return $("<div>").html(html).text()},value2str:function(value){return String(value)},str2value:function(str){return str},value2submit:function(value){return value},value2input:function(value){this.$input.val(value)},input2value:function(){return this.$input.val()},activate:function(){this.$input.is(":visible")&&this.$input.focus()},clear:function(){this.$input.val(null)},escape:function(str){return $("<div>").text(str).html()},autosubmit:function(){},destroy:function(){},setClass:function(){this.options.inputclass&&this.$input.addClass(this.options.inputclass)},setAttr:function(attr){void 0!==this.options[attr]&&null!==this.options[attr]&&this.$input.attr(attr,this.options[attr])},option:function(key,value){this.options[key]=value}},AbstractInput.defaults={tpl:"",inputclass:null,escape:!0,scope:null,showbuttons:!0},$.extend($.fn.editabletypes,{abstractinput:AbstractInput})}(window.jQuery),function($){"use strict";var List=function(options){};$.fn.editableutils.inherit(List,$.fn.editabletypes.abstractinput),$.extend(List.prototype,{render:function(){var deferred=$.Deferred();return this.error=null,this.onSourceReady((function(){this.renderList(),deferred.resolve()}),(function(){this.error=this.options.sourceError,deferred.resolve()})),deferred.promise()},html2value:function(html){return null},value2html:function(value,element,display,response){var deferred=$.Deferred(),success=function(){"function"==typeof display?display.call(element,value,this.sourceData,response):this.value2htmlFinal(value,element),deferred.resolve()};return null===value?success.call(this):this.onSourceReady(success,(function(){deferred.resolve()})),deferred.promise()},onSourceReady:function(success,error){var source;if($.isFunction(this.options.source)?(source=this.options.source.call(this.options.scope),this.sourceData=null):source=this.options.source,this.options.sourceCache&&$.isArray(this.sourceData))success.call(this);else{try{source=$.fn.editableutils.tryParseJson(source,!1)}catch(e){return void error.call(this)}if("string"==typeof source){if(this.options.sourceCache){var cacheID=source,cache;if($(document).data(cacheID)||$(document).data(cacheID,{}),!1===(cache=$(document).data(cacheID)).loading&&cache.sourceData)return this.sourceData=cache.sourceData,this.doPrepend(),void success.call(this);if(!0===cache.loading)return cache.callbacks.push($.proxy((function(){this.sourceData=cache.sourceData,this.doPrepend(),success.call(this)}),this)),void cache.err_callbacks.push($.proxy(error,this));cache.loading=!0,cache.callbacks=[],cache.err_callbacks=[]}var ajaxOptions=$.extend({url:source,type:"get",cache:!1,dataType:"json",success:$.proxy((function(data){cache&&(cache.loading=!1),this.sourceData=this.makeArray(data),$.isArray(this.sourceData)?(cache&&(cache.sourceData=this.sourceData,$.each(cache.callbacks,(function(){this.call()}))),this.doPrepend(),success.call(this)):(error.call(this),cache&&$.each(cache.err_callbacks,(function(){this.call()})))}),this),error:$.proxy((function(){error.call(this),cache&&(cache.loading=!1,$.each(cache.err_callbacks,(function(){this.call()})))}),this)},this.options.sourceOptions);$.ajax(ajaxOptions)}else this.sourceData=this.makeArray(source),$.isArray(this.sourceData)?(this.doPrepend(),success.call(this)):error.call(this)}},doPrepend:function(){null!==this.options.prepend&&void 0!==this.options.prepend&&($.isArray(this.prependData)||($.isFunction(this.options.prepend)&&(this.options.prepend=this.options.prepend.call(this.options.scope)),this.options.prepend=$.fn.editableutils.tryParseJson(this.options.prepend,!0),"string"==typeof this.options.prepend&&(this.options.prepend={"":this.options.prepend}),this.prependData=this.makeArray(this.options.prepend)),$.isArray(this.prependData)&&$.isArray(this.sourceData)&&(this.sourceData=this.prependData.concat(this.sourceData)))},renderList:function(){},value2htmlFinal:function(value,element){},makeArray:function(data){var count,obj,result=[],item,iterateItem;if(!data||"string"==typeof data)return null;if($.isArray(data)){iterateItem=function(k,v){if(obj={value:k,text:v},count++>=2)return!1};for(var i=0;i<data.length;i++)"object"==typeof(item=data[i])?(count=0,$.each(item,iterateItem),1===count?result.push(obj):count>1&&(item.children&&(item.children=this.makeArray(item.children)),result.push(item))):result.push({value:item,text:item})}else $.each(data,(function(k,v){result.push({value:k,text:v})}));return result},option:function(key,value){this.options[key]=value,"source"===key&&(this.sourceData=null),"prepend"===key&&(this.prependData=null)}}),List.defaults=$.extend({},$.fn.editabletypes.abstractinput.defaults,{source:null,prepend:!1,sourceError:"Error when loading list",sourceCache:!0,sourceOptions:null}),$.fn.editabletypes.list=List}(window.jQuery),function($){"use strict";var Text=function(options){this.init("text",options,Text.defaults)};$.fn.editableutils.inherit(Text,$.fn.editabletypes.abstractinput),$.extend(Text.prototype,{render:function(){this.renderClear(),this.setClass(),this.setAttr("placeholder")},activate:function(){this.$input.is(":visible")&&(this.$input.focus(),this.$input.is("input,textarea")&&!this.$input.is('[type="checkbox"],[type="range"]')&&$.fn.editableutils.setCursorPosition(this.$input.get(0),this.$input.val().length),this.toggleClear&&this.toggleClear())},renderClear:function(){this.options.clear&&(this.$clear=$('<span class="editable-clear-x"></span>'),this.$input.after(this.$clear).css("padding-right",24).keyup($.proxy((function(e){if(!~$.inArray(e.keyCode,[40,38,9,13,27])){clearTimeout(this.t);var that=this;this.t=setTimeout((function(){that.toggleClear(e)}),100)}}),this)).parent().css("position","relative"),this.$clear.click($.proxy(this.clear,this)))},postrender:function(){},toggleClear:function(e){if(this.$clear){var len=this.$input.val().length,visible=this.$clear.is(":visible");len&&!visible&&this.$clear.show(),!len&&visible&&this.$clear.hide()}},clear:function(){this.$clear.hide(),this.$input.val("").focus()}}),Text.defaults=$.extend({},$.fn.editabletypes.abstractinput.defaults,{tpl:'<input type="text">',placeholder:null,clear:!0}),$.fn.editabletypes.text=Text}(window.jQuery),function($){"use strict";var Textarea=function(options){this.init("textarea",options,Textarea.defaults)};$.fn.editableutils.inherit(Textarea,$.fn.editabletypes.abstractinput),$.extend(Textarea.prototype,{render:function(){this.setClass(),this.setAttr("placeholder"),this.setAttr("rows"),this.$input.keydown((function(e){e.ctrlKey&&13===e.which&&$(this).closest("form").submit()}))},activate:function(){$.fn.editabletypes.text.prototype.activate.call(this)}}),Textarea.defaults=$.extend({},$.fn.editabletypes.abstractinput.defaults,{tpl:"<textarea></textarea>",inputclass:"input-large",placeholder:null,rows:7}),$.fn.editabletypes.textarea=Textarea}(window.jQuery),function($){"use strict";var Select=function(options){this.init("select",options,Select.defaults)};$.fn.editableutils.inherit(Select,$.fn.editabletypes.list),$.extend(Select.prototype,{renderList:function(){this.$input.empty();var escape=this.options.escape,fillItems=function($el,data){var attr;if($.isArray(data))for(var i=0;i<data.length;i++)if(attr={},data[i].children)attr.label=data[i].text,$el.append(fillItems($("<optgroup>",attr),data[i].children));else{attr.value=data[i].value,data[i].disabled&&(attr.disabled=!0);var $option=$("<option>",attr);$option[escape?"text":"html"](data[i].text),$el.append($option)}return $el};fillItems(this.$input,this.sourceData),this.setClass(),this.$input.on("keydown.editable",(function(e){13===e.which&&$(this).closest("form").submit()}))},value2htmlFinal:function(value,element){var text="",items=$.fn.editableutils.itemsByValue(value,this.sourceData);items.length&&(text=items[0].text),$.fn.editabletypes.abstractinput.prototype.value2html.call(this,text,element)},autosubmit:function(){this.$input.off("keydown.editable").on("change.editable",(function(){$(this).closest("form").submit()}))}}),Select.defaults=$.extend({},$.fn.editabletypes.list.defaults,{tpl:"<select></select>"}),$.fn.editabletypes.select=Select}(window.jQuery),function($){"use strict";var Checklist=function(options){this.init("checklist",options,Checklist.defaults)};$.fn.editableutils.inherit(Checklist,$.fn.editabletypes.list),$.extend(Checklist.prototype,{renderList:function(){var $label,$div;if(this.$tpl.empty(),$.isArray(this.sourceData)){for(var i=0;i<this.sourceData.length;i++){($label=$('<label class="form-check-label">'))[this.options.escape?"text":"html"](" "+this.sourceData[i].text);var $checkbox=$("<input>",{type:"checkbox",class:"form-check-input",value:this.sourceData[i].value});$('<div class="form-check">').append($label).append($checkbox).appendTo(this.$tpl)}this.$input=this.$tpl.find('input[type="checkbox"]'),this.setClass()}},value2str:function(value){return $.isArray(value)?value.sort().join($.trim(this.options.separator)):""},str2value:function(str){var reg,value=null;return"string"==typeof str&&str.length?(reg=new RegExp("\\s*"+$.trim(this.options.separator)+"\\s*"),value=str.split(reg)):value=$.isArray(str)?str:[str],value},value2input:function(value){this.$input.prop("checked",!1),$.isArray(value)&&value.length&&this.$input.each((function(i,el){var $el=$(el);$.each(value,(function(j,val){$el.val()==val&&$el.prop("checked",!0)}))}))},input2value:function(){var checked=[];return this.$input.filter(":checked").each((function(i,el){checked.push($(el).val())})),checked},value2htmlFinal:function(value,element){var html=[],checked=$.fn.editableutils.itemsByValue(value,this.sourceData),escape=this.options.escape;checked.length?($.each(checked,(function(i,v){var text=escape?$.fn.editableutils.escape(v.text):v.text;html.push(text)})),$(element).html(html.join("<br>"))):$(element).empty()},activate:function(){this.$input.first().focus()},autosubmit:function(){this.$input.on("keydown",(function(e){13===e.which&&$(this).closest("form").submit()}))}}),Checklist.defaults=$.extend({},$.fn.editabletypes.list.defaults,{tpl:'<div class="editable-checklist"></div>',inputclass:null,separator:","}),$.fn.editabletypes.checklist=Checklist}(window.jQuery),function($){"use strict";var Password=function(options){this.init("password",options,Password.defaults)};$.fn.editableutils.inherit(Password,$.fn.editabletypes.text),$.extend(Password.prototype,{value2html:function(value,element){value?$(element).text("[hidden]"):$(element).empty()},html2value:function(html){return null}}),Password.defaults=$.extend({},$.fn.editabletypes.text.defaults,{tpl:'<input type="password">'}),$.fn.editabletypes.password=Password}(window.jQuery),function($){"use strict";var Email=function(options){this.init("email",options,Email.defaults)};$.fn.editableutils.inherit(Email,$.fn.editabletypes.text),Email.defaults=$.extend({},$.fn.editabletypes.text.defaults,{tpl:'<input type="email">'}),$.fn.editabletypes.email=Email}(window.jQuery),function($){"use strict";var Url=function(options){this.init("url",options,Url.defaults)};$.fn.editableutils.inherit(Url,$.fn.editabletypes.text),Url.defaults=$.extend({},$.fn.editabletypes.text.defaults,{tpl:'<input type="url">'}),$.fn.editabletypes.url=Url}(window.jQuery),function($){"use strict";var Tel=function(options){this.init("tel",options,Tel.defaults)};$.fn.editableutils.inherit(Tel,$.fn.editabletypes.text),Tel.defaults=$.extend({},$.fn.editabletypes.text.defaults,{tpl:'<input type="tel">'}),$.fn.editabletypes.tel=Tel}(window.jQuery),function($){"use strict";var NumberInput=function(options){this.init("number",options,NumberInput.defaults)};$.fn.editableutils.inherit(NumberInput,$.fn.editabletypes.text),$.extend(NumberInput.prototype,{render:function(){NumberInput.superclass.render.call(this),this.setAttr("min"),this.setAttr("max"),this.setAttr("step")},postrender:function(){this.$clear&&this.$clear.css({right:24})}}),NumberInput.defaults=$.extend({},$.fn.editabletypes.text.defaults,{tpl:'<input type="number">',inputclass:"form-control-sm",min:null,max:null,step:null}),$.fn.editabletypes.number=NumberInput}(window.jQuery),function($){"use strict";var Range=function(options){this.init("range",options,Range.defaults)};$.fn.editableutils.inherit(Range,$.fn.editabletypes.number),$.extend(Range.prototype,{render:function(){this.$input=this.$tpl.filter("input"),this.setClass(),this.setAttr("min"),this.setAttr("max"),this.setAttr("step"),this.$input.on("input",(function(){$(this).siblings("output").text($(this).val())}))},activate:function(){this.$input.focus()}}),Range.defaults=$.extend({},$.fn.editabletypes.number.defaults,{tpl:'<input type="range"><output style="width: 30px; display: inline-block"></output>',inputclass:"input-medium"}),$.fn.editabletypes.range=Range}(window.jQuery),function($){"use strict";var Time=function(options){this.init("time",options,Time.defaults)};$.fn.editableutils.inherit(Time,$.fn.editabletypes.abstractinput),$.extend(Time.prototype,{render:function(){this.setClass()}}),Time.defaults=$.extend({},$.fn.editabletypes.abstractinput.defaults,{tpl:'<input type="time">'}),$.fn.editabletypes.time=Time}(window.jQuery),function($){"use strict";var Constructor=function(options){if(this.init("select2",options,Constructor.defaults),options.select2=options.select2||{},this.sourceData=null,options.placeholder&&(options.select2.placeholder=options.placeholder),!options.select2.tags&&options.source){var source=options.source;$.isFunction(options.source)&&(source=options.source.call(options.scope)),"string"==typeof source?(options.select2.ajax=options.select2.ajax||{},options.select2.ajax.data||(options.select2.ajax.data=function(term){return{query:term}}),options.select2.ajax.results||(options.select2.ajax.results=function(data){return{results:data}}),options.select2.ajax.url=source):(this.sourceData=this.convertSource(source),options.select2.data=this.sourceData)}if(this.options.select2=$.extend({},Constructor.defaults.select2,options.select2),this.isMultiple=this.options.select2.tags||this.options.select2.multiple,this.isRemote="ajax"in this.options.select2,this.idFunc=this.options.select2.id,"function"!=typeof this.idFunc){var idKey=this.idFunc||"id";this.idFunc=function(e){return e[idKey]}}this.formatSelection=this.options.select2.formatSelection,"function"!=typeof this.formatSelection&&(this.formatSelection=function(e){return e.text})};$.fn.editableutils.inherit(Constructor,$.fn.editabletypes.abstractinput),$.extend(Constructor.prototype,{render:function(){this.setClass(),this.isRemote&&this.$input.on("select2-loaded",$.proxy((function(e){this.sourceData=e.items.results}),this)),this.isMultiple&&this.$input.on("change",(function(){$(this).closest("form").parent().triggerHandler("resize")}))},value2html:function(value,element){var text="",data,that=this;this.options.select2.tags?data=value:this.sourceData&&(data=$.fn.editableutils.itemsByValue(value,this.sourceData,this.idFunc)),$.isArray(data)?(text=[],$.each(data,(function(k,v){text.push(v&&"object"==typeof v?that.formatSelection(v):v)}))):data&&(text=that.formatSelection(data)),text=$.isArray(text)?text.join(this.options.viewseparator):text,Constructor.superclass.value2html.call(this,text,element)},html2value:function(html){return this.options.select2.tags?this.str2value(html,this.options.viewseparator):null},value2input:function(value){if($.isArray(value)&&(value=value.join(this.getSeparator())),this.$input.data("select2")?this.$input.val(value).trigger("change",!0):(this.$input.val(value),this.$input.select2(this.options.select2)),this.isRemote&&!this.isMultiple&&!this.options.select2.initSelection){var customId=this.options.select2.id,customText=this.options.select2.formatSelection;if(!customId&&!customText){var $el=$(this.options.scope);if(!$el.data("editable").isEmpty){var data={id:value,text:$el.text()};this.$input.select2("data",data)}}}},input2value:function(){return this.$input.select2("val")},str2value:function(str,separator){if("string"!=typeof str||!this.isMultiple)return str;var val,i,l;if(separator=separator||this.getSeparator(),null===str||str.length<1)return null;for(i=0,l=(val=str.split(separator)).length;i<l;i+=1)val[i]=$.trim(val[i]);return val},autosubmit:function(){this.$input.on("change",(function(e,isInitial){isInitial||$(this).closest("form").submit()}))},getSeparator:function(){return this.options.select2.separator||$.fn.select2.defaults.separator},convertSource:function(source){if($.isArray(source)&&source.length&&void 0!==source[0].value)for(var i=0;i<source.length;i++)void 0!==source[i].value&&(source[i].id=source[i].value,delete source[i].value);return source},activate:function(){this.$input.select2("open")},destroy:function(){this.$input&&this.$input.data("select2")&&this.$input.select2("destroy")}}),Constructor.defaults=$.extend({},$.fn.editabletypes.abstractinput.defaults,{tpl:'<input type="hidden">',select2:null,placeholder:null,source:null,viewseparator:", "}),$.fn.editabletypes.select2=Constructor}(window.jQuery),function($){var Combodate=function(element,options){this.$element=$(element),this.$element.is("input")?(this.options=$.extend({},$.fn.combodate.defaults,options,this.$element.data()),this.init()):$.error("Combodate should be applied to INPUT element")};Combodate.prototype={constructor:Combodate,init:function(){this.map={day:["D","date"],month:["M","month"],year:["Y","year"],hour:["[Hh]","hours"],minute:["m","minutes"],second:["s","seconds"],ampm:["[Aa]",""]},this.$widget=$('<span class="combodate"></span>').html(this.getTemplate()),this.initCombos(),this.datetime=null,this.$widget.on("change","select",$.proxy((function(e){this.$element.val(this.getValue()).change(),this.options.smartDays&&($(e.target).is(".month")||$(e.target).is(".year"))&&this.fillCombo("day")}),this)),this.$widget.find("select").css("width","auto"),this.$element.hide().after(this.$widget),this.setValue(this.$element.val()||this.options.value)},getTemplate:function(){var tpl=this.options.template,inputDisabled=this.$element.prop("disabled"),customClass=this.options.customClass;return $.each(this.map,(function(k,v){v=v[0];var r=new RegExp(v+"+"),token=v.length>1?v.substring(1,2):v;tpl=tpl.replace(r,"{"+token+"}")})),tpl=tpl.replace(/ /g,"&nbsp;"),$.each(this.map,(function(k,v){var token=(v=v[0]).length>1?v.substring(1,2):v;tpl=tpl.replace("{"+token+"}",'<select class="'+k+" "+customClass+'"'+(inputDisabled?' disabled="disabled"':"")+"></select>")})),tpl},initCombos:function(){for(var k in this.map){var $c=this.$widget.find("."+k);this["$"+k]=$c.length?$c:null,this.fillCombo(k)}},fillCombo:function(k){var $combo=this["$"+k];if($combo){var f,items=this["fill"+k.charAt(0).toUpperCase()+k.slice(1)](),value=$combo.val();$combo.empty();for(var i=0;i<items.length;i++)$combo.append('<option value="'+items[i][0]+'">'+items[i][1]+"</option>");$combo.val(value)}},fillCommon:function(key){var values=[],relTime;if("name"===this.options.firstItem){var header="function"==typeof(relTime=moment.localeData?moment.localeData()._relativeTime:moment.relativeTime||moment.langData()._relativeTime)[key]?relTime[key](1,!0,key,!1):relTime[key];header=header.split(" ").reverse()[0],values.push(["",header])}else"empty"===this.options.firstItem&&values.push(["",""]);return values},fillDay:function(){var items=this.fillCommon("d"),name,i,twoDigit=-1!==this.options.template.indexOf("DD"),daysCount=31;if(this.options.smartDays&&this.$month&&this.$year){var month=parseInt(this.$month.val(),10),year=parseInt(this.$year.val(),10);isNaN(month)||isNaN(year)||(daysCount=moment([year,month]).daysInMonth())}for(i=1;i<=daysCount;i++)name=twoDigit?this.leadZero(i):i,items.push([i,name]);return items},fillMonth:function(){var items=this.fillCommon("M"),name,i,longNamesNum=-1!==this.options.template.indexOf("MMMMMM"),shortNamesNum=-1!==this.options.template.indexOf("MMMMM"),longNames=-1!==this.options.template.indexOf("MMMM"),shortNames=-1!==this.options.template.indexOf("MMM"),twoDigit=-1!==this.options.template.indexOf("MM");for(i=0;i<=11;i++)name=longNamesNum?moment().date(1).month(i).format("MM - MMMM"):shortNamesNum?moment().date(1).month(i).format("MM - MMM"):longNames?moment().date(1).month(i).format("MMMM"):shortNames?moment().date(1).month(i).format("MMM"):twoDigit?this.leadZero(i+1):i+1,items.push([i,name]);return items},fillYear:function(){var items=[],name,i,longNames=-1!==this.options.template.indexOf("YYYY");for(i=this.options.maxYear;i>=this.options.minYear;i--)name=longNames?i:(i+"").substring(2),items[this.options.yearDescending?"push":"unshift"]([i,name]);return items=this.fillCommon("y").concat(items)},fillHour:function(){var items=this.fillCommon("h"),name,i,h12=-1!==this.options.template.indexOf("h"),h24=-1!==this.options.template.indexOf("H"),twoDigit=-1!==this.options.template.toLowerCase().indexOf("hh"),min,max=h12?12:23;for(i=h12?1:0;i<=max;i++)name=twoDigit?this.leadZero(i):i,items.push([i,name]);return items},fillMinute:function(){var items=this.fillCommon("m"),name,i,twoDigit=-1!==this.options.template.indexOf("mm");for(i=0;i<=59;i+=this.options.minuteStep)name=twoDigit?this.leadZero(i):i,items.push([i,name]);return items},fillSecond:function(){var items=this.fillCommon("s"),name,i,twoDigit=-1!==this.options.template.indexOf("ss");for(i=0;i<=59;i+=this.options.secondStep)name=twoDigit?this.leadZero(i):i,items.push([i,name]);return items},fillAmpm:function(){var ampmL=-1!==this.options.template.indexOf("a"),ampmU=-1!==this.options.template.indexOf("A"),items;return[["am",ampmL?"am":"AM"],["pm",ampmL?"pm":"PM"]]},getValue:function(format){var dt,values={},that=this,notSelected=!1;return $.each(this.map,(function(k,v){if("ampm"!==k){var defaultValue;if(that["$"+k])values[k]=parseInt(that["$"+k].val(),10);else defaultValue=that.datetime?that.datetime[v[1]]():"day"===k?1:0,values[k]=defaultValue;return isNaN(values[k])?(notSelected=!0,!1):void 0}})),notSelected?"":(this.$ampm&&(12===values.hour?values.hour="am"===this.$ampm.val()?0:12:values.hour="am"===this.$ampm.val()?values.hour:values.hour+12),dt=moment([values.year,values.month,values.day,values.hour,values.minute,values.second]),this.highlight(dt),null===(format=void 0===format?this.options.format:format)?dt.isValid()?dt:null:dt.isValid()?dt.format(format):"")},setValue:function(value){if(value){var dt="string"==typeof value?moment(value,this.options.format,!0):moment(value),that=this,values={};dt.isValid()?($.each(this.map,(function(k,v){"ampm"!==k&&(values[k]=dt[v[1]]())})),this.$ampm&&(values.hour>=12?(values.ampm="pm",values.hour>12&&(values.hour-=12)):(values.ampm="am",0===values.hour&&(values.hour=12))),$.each(values,(function(k,v){that["$"+k]&&("minute"===k&&that.options.minuteStep>1&&that.options.roundTime&&(v=getNearest(that["$"+k],v)),"second"===k&&that.options.secondStep>1&&that.options.roundTime&&(v=getNearest(that["$"+k],v)),that["$"+k].val(v))})),this.options.smartDays&&this.fillCombo("day"),this.$element.val(dt.format(this.options.format)).change(),this.datetime=dt):this.datetime=null}function getNearest($select,value){var delta={};return $select.children("option").each((function(i,opt){var optValue=$(opt).attr("value"),distance;""!==optValue&&(distance=Math.abs(optValue-value),(void 0===delta.distance||distance<delta.distance)&&(delta={value:optValue,distance:distance}))})),delta.value}},highlight:function(dt){dt.isValid()?this.options.errorClass?this.$widget.removeClass(this.options.errorClass):this.$widget.find("select").css("border-color",this.borderColor):this.options.errorClass?this.$widget.addClass(this.options.errorClass):(this.borderColor||(this.borderColor=this.$widget.find("select").css("border-color")),this.$widget.find("select").css("border-color","red"))},leadZero:function(v){return v<=9?"0"+v:v},destroy:function(){this.$widget.remove(),this.$element.removeData("combodate").show()}},$.fn.combodate=function(option){var d,args=Array.apply(null,arguments);return args.shift(),"getValue"===option&&this.length&&(d=this.eq(0).data("combodate"))?d.getValue.apply(d,args):this.each((function(){var $this=$(this),data=$this.data("combodate"),options="object"==typeof option&&option;data||$this.data("combodate",data=new Combodate(this,options)),"string"==typeof option&&"function"==typeof data[option]&&data[option].apply(data,args)}))},$.fn.combodate.defaults={format:"DD-MM-YYYY HH:mm",template:"D / MMM / YYYY   H : mm",value:null,minYear:1970,maxYear:(new Date).getFullYear(),yearDescending:!0,minuteStep:5,secondStep:1,firstItem:"empty",errorClass:null,customClass:"",roundTime:!0,smartDays:!1}}(window.jQuery),function($){"use strict";var Constructor=function(options){this.init("combodate",options,Constructor.defaults),this.options.viewformat||(this.options.viewformat=this.options.format),options.combodate=$.fn.editableutils.tryParseJson(options.combodate,!0),this.options.combodate=$.extend({},Constructor.defaults.combodate,options.combodate,{format:this.options.format,template:this.options.template})};$.fn.editableutils.inherit(Constructor,$.fn.editabletypes.abstractinput),$.extend(Constructor.prototype,{render:function(){this.$input.combodate(this.options.combodate),"bs3"===$.fn.editableform.engine&&this.$input.siblings().find("select").addClass("form-control"),this.options.inputclass&&this.$input.siblings().find("select").addClass(this.options.inputclass)},value2html:function(value,element){var text=value?value.format(this.options.viewformat):"";Constructor.superclass.value2html.call(this,text,element)},html2value:function(html){return html?moment(html,this.options.viewformat):null},value2str:function(value){return value?value.format(this.options.format):""},str2value:function(str){return str?moment(str,this.options.format):null},value2submit:function(value){return this.value2str(value)},value2input:function(value){this.$input.combodate("setValue",value)},input2value:function(){return this.$input.combodate("getValue",null)},activate:function(){this.$input.siblings(".combodate").find("select").eq(0).focus()},autosubmit:function(){}}),Constructor.defaults=$.extend({},$.fn.editabletypes.abstractinput.defaults,{tpl:'<input type="text">',inputclass:null,format:"YYYY-MM-DD",viewformat:null,template:"D / MMM / YYYY",combodate:null}),$.fn.editabletypes.combodate=Constructor}(window.jQuery),function($){"use strict";var pInitInput=$.fn.editableform.Constructor.prototype.initInput;$.extend($.fn.editableform.Constructor.prototype,{initTemplate:function(){this.$form=$($.fn.editableform.template),this.$form.find(".control-group").addClass("form-group"),this.$form.find(".editable-error-block").addClass("help-block")},initInput:function(){pInitInput.apply(this);var emptyInputClass=null===this.input.options.inputclass||!1===this.input.options.inputclass,defaultClass="form-control-sm",stdtypes="text,select,textarea,password,email,url,tel,number,range,time,typeaheadjs".split(",");if(~$.inArray(this.input.type,stdtypes)){if("select"===this.input.type){this.input.$input.addClass("form-select");var defaultClass="form-select-sm"}else this.input.$input.addClass("form-control");emptyInputClass&&(this.input.options.inputclass=defaultClass,this.input.$input.addClass(defaultClass))}for(var $btn=this.$form.find(".editable-buttons"),classes=emptyInputClass?[defaultClass]:this.input.options.inputclass.split(" "),i=0;i<classes.length;i++)"input-lg"===classes[i].toLowerCase()&&$btn.find("button").removeClass("btn-sm").addClass("btn-lg")}}),$.fn.editableform.buttons='<button type="submit" class="btn btn-primary btn-sm editable-submit"><i class="bi bi-check-lg" aria-hidden="true"></i></button><button type="button" class="btn btn-outline-secondary btn-sm editable-cancel"><i class="bi bi-x-lg" aria-hidden="true"></i></button>',$.fn.editableform.errorGroupClass="has-error",$.fn.editableform.errorBlockClass=null,$.fn.editableform.engine="bs4"}(window.jQuery),function($){"use strict";$.extend($.fn.editableContainer.Popup.prototype,{containerName:"popover",containerDataName:"bs.popover",innerCss:".popover-body",defaults:bootstrap.Popover.Default,initContainer:function(){var t;$.extend(this.containerOptions,{trigger:"manual",selector:!1,content:" ",template:this.defaults.template}),this.$element.data("template")&&(t=this.$element.data("template"),this.$element.removeData("template")),this.call(this.containerOptions),t&&this.$element.data("template",t)},innerShow:function(){this.call("show")},innerHide:function(){this.call("hide")},innerDestroy:function(){this.call("dispose")},setContainerOption:function(key,value){this.container().options[key]=value},setPosition:function(){(function(){}).call(this.container())},call:function(){return $(this.$element).data(this.containerDataName)||$(this.$element).data(this.containerDataName,bootstrap[this.containerName.replace(this.containerName[0],this.containerName[0].toUpperCase())].getOrCreateInstance(this.$element,this.containerOptions)),this.$element[this.containerName].apply(this.$element,arguments)},tip:function(){return this.container()?$(this.container().tip):null}})}(window.jQuery),function($){function UTCDate(){return new Date(Date.UTC.apply(Date,arguments))}function UTCToday(){var today=new Date;return UTCDate(today.getUTCFullYear(),today.getUTCMonth(),today.getUTCDate())}var Datepicker=function(element,options){var that=this;this._process_options(options),this.element=$(element),this.isInline=!1,this.isInput=this.element.is("input"),this.component=!!this.element.is(".date")&&this.element.find(".add-on, .btn"),this.hasInput=this.component&&this.element.find("input").length,this.component&&0===this.component.length&&(this.component=!1),this.picker=$(DPGlobal.template),this._buildEvents(),this._attachEvents(),this.isInline?this.picker.addClass("datepicker-inline").appendTo(this.element):this.picker.addClass("datepicker-dropdown dropdown-menu"),this.o.rtl&&(this.picker.addClass("datepicker-rtl"),this.picker.find(".prev i, .next i").toggleClass("icon-arrow-left icon-arrow-right")),this.viewMode=this.o.startView,this.o.calendarWeeks&&this.picker.find("tfoot th.today").attr("colspan",(function(i,val){return parseInt(val)+1})),this._allow_update=!1,this.setStartDate(this.o.startDate),this.setEndDate(this.o.endDate),this.setDaysOfWeekDisabled(this.o.daysOfWeekDisabled),this.fillDow(),this.fillMonths(),this._allow_update=!0,this.update(),this.showMode(),this.isInline&&this.show()};Datepicker.prototype={constructor:Datepicker,_process_options:function(opts){this._o=$.extend({},this._o,opts);var o=this.o=$.extend({},this._o),lang=o.language;switch(dates[lang]||(lang=lang.split("-")[0],dates[lang]||(lang=defaults.language)),o.language=lang,o.startView){case 2:case"decade":o.startView=2;break;case 1:case"year":o.startView=1;break;default:o.startView=0}switch(o.minViewMode){case 1:case"months":o.minViewMode=1;break;case 2:case"years":o.minViewMode=2;break;default:o.minViewMode=0}o.startView=Math.max(o.startView,o.minViewMode),o.weekStart%=7,o.weekEnd=(o.weekStart+6)%7;var format=DPGlobal.parseFormat(o.format);o.startDate!==-1/0&&(o.startDate=DPGlobal.parseDate(o.startDate,format,o.language)),o.endDate!==1/0&&(o.endDate=DPGlobal.parseDate(o.endDate,format,o.language)),o.daysOfWeekDisabled=o.daysOfWeekDisabled||[],$.isArray(o.daysOfWeekDisabled)||(o.daysOfWeekDisabled=o.daysOfWeekDisabled.split(/[,\s]*/)),o.daysOfWeekDisabled=$.map(o.daysOfWeekDisabled,(function(d){return parseInt(d,10)}))},_events:[],_secondaryEvents:[],_applyEvents:function(evs){for(var i=0,el,ev;i<evs.length;i++)el=evs[i][0],ev=evs[i][1],el.on(ev)},_unapplyEvents:function(evs){for(var i=0,el,ev;i<evs.length;i++)el=evs[i][0],ev=evs[i][1],el.off(ev)},_buildEvents:function(){this.isInput?this._events=[[this.element,{focus:$.proxy(this.show,this),keyup:$.proxy(this.update,this),keydown:$.proxy(this.keydown,this)}]]:this.component&&this.hasInput?this._events=[[this.element.find("input"),{focus:$.proxy(this.show,this),keyup:$.proxy(this.update,this),keydown:$.proxy(this.keydown,this)}],[this.component,{click:$.proxy(this.show,this)}]]:this.element.is("div")?this.isInline=!0:this._events=[[this.element,{click:$.proxy(this.show,this)}]],this._secondaryEvents=[[this.picker,{click:$.proxy(this.click,this)}],[$(window),{resize:$.proxy(this.place,this)}],[$(document),{mousedown:$.proxy((function(e){this.element.is(e.target)||this.element.find(e.target).size()||this.picker.is(e.target)||this.picker.find(e.target).size()||this.hide()}),this)}]]},_attachEvents:function(){this._detachEvents(),this._applyEvents(this._events)},_detachEvents:function(){this._unapplyEvents(this._events)},_attachSecondaryEvents:function(){this._detachSecondaryEvents(),this._applyEvents(this._secondaryEvents)},_detachSecondaryEvents:function(){this._unapplyEvents(this._secondaryEvents)},_trigger:function(event,altdate){var date=altdate||this.date,local_date=new Date(date.getTime()+6e4*date.getTimezoneOffset());this.element.trigger({type:event,date:local_date,format:$.proxy((function(altformat){var format=altformat||this.o.format;return DPGlobal.formatDate(date,format,this.o.language)}),this)})},show:function(e){this.isInline||this.picker.appendTo("body"),this.picker.show(),this.height=this.component?this.component.outerHeight():this.element.outerHeight(),this.place(),this._attachSecondaryEvents(),e&&e.preventDefault(),this._trigger("show")},hide:function(e){this.isInline||this.picker.is(":visible")&&(this.picker.hide().detach(),this._detachSecondaryEvents(),this.viewMode=this.o.startView,this.showMode(),this.o.forceParse&&(this.isInput&&this.element.val()||this.hasInput&&this.element.find("input").val())&&this.setValue(),this._trigger("hide"))},remove:function(){this.hide(),this._detachEvents(),this._detachSecondaryEvents(),this.picker.remove(),delete this.element.data().datepicker,this.isInput||delete this.element.data().date},getDate:function(){var d=this.getUTCDate();return new Date(d.getTime()+6e4*d.getTimezoneOffset())},getUTCDate:function(){return this.date},setDate:function(d){this.setUTCDate(new Date(d.getTime()-6e4*d.getTimezoneOffset()))},setUTCDate:function(d){this.date=d,this.setValue()},setValue:function(){var formatted=this.getFormattedDate();this.isInput?this.element.val(formatted):this.component&&this.element.find("input").val(formatted)},getFormattedDate:function(format){return void 0===format&&(format=this.o.format),DPGlobal.formatDate(this.date,format,this.o.language)},setStartDate:function(startDate){this._process_options({startDate:startDate}),this.update(),this.updateNavArrows()},setEndDate:function(endDate){this._process_options({endDate:endDate}),this.update(),this.updateNavArrows()},setDaysOfWeekDisabled:function(daysOfWeekDisabled){this._process_options({daysOfWeekDisabled:daysOfWeekDisabled}),this.update(),this.updateNavArrows()},place:function(){if(!this.isInline){var zIndex=parseInt(this.element.parents().filter((function(){return"auto"!=$(this).css("z-index")})).first().css("z-index"))+10,offset=this.component?this.component.parent().offset():this.element.offset(),height=this.component?this.component.outerHeight(!0):this.element.outerHeight(!0);this.picker.css({top:offset.top+height,left:offset.left,zIndex:zIndex})}},_allow_update:!0,update:function(){if(this._allow_update){var date,fromArgs=!1;arguments&&arguments.length&&("string"==typeof arguments[0]||arguments[0]instanceof Date)?(date=arguments[0],fromArgs=!0):(date=this.isInput?this.element.val():this.element.data("date")||this.element.find("input").val(),delete this.element.data().date),this.date=DPGlobal.parseDate(date,this.o.format,this.o.language),fromArgs&&this.setValue(),this.date<this.o.startDate?this.viewDate=new Date(this.o.startDate):this.date>this.o.endDate?this.viewDate=new Date(this.o.endDate):this.viewDate=new Date(this.date),this.fill()}},fillDow:function(){var dowCnt=this.o.weekStart,html="<tr>";if(this.o.calendarWeeks){var cell='<th class="cw">&nbsp;</th>';html+=cell,this.picker.find(".datepicker-days thead tr:first-child").prepend(cell)}for(;dowCnt<this.o.weekStart+7;)html+='<th class="dow">'+dates[this.o.language].daysMin[dowCnt++%7]+"</th>";html+="</tr>",this.picker.find(".datepicker-days thead").append(html)},fillMonths:function(){for(var html="",i=0;i<12;)html+='<span class="month">'+dates[this.o.language].monthsShort[i++]+"</span>";this.picker.find(".datepicker-months td").html(html)},setRange:function(range){range&&range.length?this.range=$.map(range,(function(d){return d.valueOf()})):delete this.range,this.fill()},getClassNames:function(date){var cls=[],year=this.viewDate.getUTCFullYear(),month=this.viewDate.getUTCMonth(),currentDate=this.date.valueOf(),today=new Date;return date.getUTCFullYear()<year||date.getUTCFullYear()==year&&date.getUTCMonth()<month?cls.push("old"):(date.getUTCFullYear()>year||date.getUTCFullYear()==year&&date.getUTCMonth()>month)&&cls.push("new"),this.o.todayHighlight&&date.getUTCFullYear()==today.getFullYear()&&date.getUTCMonth()==today.getMonth()&&date.getUTCDate()==today.getDate()&&cls.push("today"),currentDate&&date.valueOf()==currentDate&&cls.push("active"),(date.valueOf()<this.o.startDate||date.valueOf()>this.o.endDate||-1!==$.inArray(date.getUTCDay(),this.o.daysOfWeekDisabled))&&cls.push("disabled"),this.range&&(date>this.range[0]&&date<this.range[this.range.length-1]&&cls.push("range"),-1!=$.inArray(date.valueOf(),this.range)&&cls.push("selected")),cls},fill:function(){var d=new Date(this.viewDate),year=d.getUTCFullYear(),month=d.getUTCMonth(),startYear=this.o.startDate!==-1/0?this.o.startDate.getUTCFullYear():-1/0,startMonth=this.o.startDate!==-1/0?this.o.startDate.getUTCMonth():-1/0,endYear=this.o.endDate!==1/0?this.o.endDate.getUTCFullYear():1/0,endMonth=this.o.endDate!==1/0?this.o.endDate.getUTCMonth():1/0,currentDate=this.date&&this.date.valueOf(),tooltip;this.picker.find(".datepicker-days thead th.datepicker-switch").text(dates[this.o.language].months[month]+" "+year),this.picker.find("tfoot th.today").text(dates[this.o.language].today).toggle(!1!==this.o.todayBtn),this.picker.find("tfoot th.clear").text(dates[this.o.language].clear).toggle(!1!==this.o.clearBtn),this.updateNavArrows(),this.fillMonths();var prevMonth=UTCDate(year,month-1,28,0,0,0,0),day=DPGlobal.getDaysInMonth(prevMonth.getUTCFullYear(),prevMonth.getUTCMonth());prevMonth.setUTCDate(day),prevMonth.setUTCDate(day-(prevMonth.getUTCDay()-this.o.weekStart+7)%7);var nextMonth=new Date(prevMonth);nextMonth.setUTCDate(nextMonth.getUTCDate()+42),nextMonth=nextMonth.valueOf();for(var html=[],clsName;prevMonth.valueOf()<nextMonth;){if(prevMonth.getUTCDay()==this.o.weekStart&&(html.push("<tr>"),this.o.calendarWeeks)){var ws=new Date(+prevMonth+(this.o.weekStart-prevMonth.getUTCDay()-7)%7*864e5),th=new Date(+ws+(11-ws.getUTCDay())%7*864e5),yth=new Date(+(yth=UTCDate(th.getUTCFullYear(),0,1))+(11-yth.getUTCDay())%7*864e5),calWeek=(th-yth)/864e5/7+1;html.push('<td class="cw">'+calWeek+"</td>")}(clsName=this.getClassNames(prevMonth)).push("day");var before=this.o.beforeShowDay(prevMonth);void 0===before?before={}:"boolean"==typeof before?before={enabled:before}:"string"==typeof before&&(before={classes:before}),!1===before.enabled&&clsName.push("disabled"),before.classes&&(clsName=clsName.concat(before.classes.split(/\s+/))),before.tooltip&&(tooltip=before.tooltip),clsName=$.unique(clsName),html.push('<td class="'+clsName.join(" ")+'"'+(tooltip?' title="'+tooltip+'"':"")+">"+prevMonth.getUTCDate()+"</td>"),prevMonth.getUTCDay()==this.o.weekEnd&&html.push("</tr>"),prevMonth.setUTCDate(prevMonth.getUTCDate()+1)}this.picker.find(".datepicker-days tbody").empty().append(html.join(""));var currentYear=this.date&&this.date.getUTCFullYear(),months=this.picker.find(".datepicker-months").find("th:eq(1)").text(year).end().find("span").removeClass("active");currentYear&&currentYear==year&&months.eq(this.date.getUTCMonth()).addClass("active"),(year<startYear||year>endYear)&&months.addClass("disabled"),year==startYear&&months.slice(0,startMonth).addClass("disabled"),year==endYear&&months.slice(endMonth+1).addClass("disabled"),html="",year=10*parseInt(year/10,10);var yearCont=this.picker.find(".datepicker-years").find("th:eq(1)").text(year+"-"+(year+9)).end().find("td");year-=1;for(var i=-1;i<11;i++)html+='<span class="year'+(-1==i?" old":10==i?" new":"")+(currentYear==year?" active":"")+(year<startYear||year>endYear?" disabled":"")+'">'+year+"</span>",year+=1;yearCont.html(html)},updateNavArrows:function(){if(this._allow_update){var d=new Date(this.viewDate),year=d.getUTCFullYear(),month=d.getUTCMonth();switch(this.viewMode){case 0:this.o.startDate!==-1/0&&year<=this.o.startDate.getUTCFullYear()&&month<=this.o.startDate.getUTCMonth()?this.picker.find(".prev").css({visibility:"hidden"}):this.picker.find(".prev").css({visibility:"visible"}),this.o.endDate!==1/0&&year>=this.o.endDate.getUTCFullYear()&&month>=this.o.endDate.getUTCMonth()?this.picker.find(".next").css({visibility:"hidden"}):this.picker.find(".next").css({visibility:"visible"});break;case 1:case 2:this.o.startDate!==-1/0&&year<=this.o.startDate.getUTCFullYear()?this.picker.find(".prev").css({visibility:"hidden"}):this.picker.find(".prev").css({visibility:"visible"}),this.o.endDate!==1/0&&year>=this.o.endDate.getUTCFullYear()?this.picker.find(".next").css({visibility:"hidden"}):this.picker.find(".next").css({visibility:"visible"})}}},click:function(e){e.preventDefault();var target=$(e.target).closest("span, td, th");if(1==target.length)switch(target[0].nodeName.toLowerCase()){case"th":switch(target[0].className){case"datepicker-switch":this.showMode(1);break;case"prev":case"next":var dir=DPGlobal.modes[this.viewMode].navStep*("prev"==target[0].className?-1:1);switch(this.viewMode){case 0:this.viewDate=this.moveMonth(this.viewDate,dir);break;case 1:case 2:this.viewDate=this.moveYear(this.viewDate,dir)}this.fill();break;case"today":var date=new Date;date=UTCDate(date.getFullYear(),date.getMonth(),date.getDate(),0,0,0),this.showMode(-2);var which="linked"==this.o.todayBtn?null:"view";this._setDate(date,which);break;case"clear":var element;this.isInput?element=this.element:this.component&&(element=this.element.find("input")),element&&element.val("").change(),this._trigger("changeDate"),this.update(),this.o.autoclose&&this.hide()}break;case"span":if(!target.is(".disabled")){if(this.viewDate.setUTCDate(1),target.is(".month")){var day=1,month=target.parent().find("span").index(target),year=this.viewDate.getUTCFullYear();this.viewDate.setUTCMonth(month),this._trigger("changeMonth",this.viewDate),1===this.o.minViewMode&&this._setDate(UTCDate(year,month,day,0,0,0,0))}else{var year=parseInt(target.text(),10)||0,day=1,month=0;this.viewDate.setUTCFullYear(year),this._trigger("changeYear",this.viewDate),2===this.o.minViewMode&&this._setDate(UTCDate(year,month,day,0,0,0,0))}this.showMode(-1),this.fill()}break;case"td":if(target.is(".day")&&!target.is(".disabled")){var day=parseInt(target.text(),10)||1,year=this.viewDate.getUTCFullYear(),month=this.viewDate.getUTCMonth();target.is(".old")?0===month?(month=11,year-=1):month-=1:target.is(".new")&&(11==month?(month=0,year+=1):month+=1),this._setDate(UTCDate(year,month,day,0,0,0,0))}}},_setDate:function(date,which){var element;which&&"date"!=which||(this.date=new Date(date)),which&&"view"!=which||(this.viewDate=new Date(date)),this.fill(),this.setValue(),this._trigger("changeDate"),this.isInput?element=this.element:this.component&&(element=this.element.find("input")),element&&(element.change(),!this.o.autoclose||which&&"date"!=which||this.hide())},moveMonth:function(date,dir){if(!dir)return date;var new_date=new Date(date.valueOf()),day=new_date.getUTCDate(),month=new_date.getUTCMonth(),mag=Math.abs(dir),new_month,test;if(dir=dir>0?1:-1,1==mag)test=-1==dir?function(){return new_date.getUTCMonth()==month}:function(){return new_date.getUTCMonth()!=new_month},new_month=month+dir,new_date.setUTCMonth(new_month),(new_month<0||new_month>11)&&(new_month=(new_month+12)%12);else{for(var i=0;i<mag;i++)new_date=this.moveMonth(new_date,dir);new_month=new_date.getUTCMonth(),new_date.setUTCDate(day),test=function(){return new_month!=new_date.getUTCMonth()}}for(;test();)new_date.setUTCDate(--day),new_date.setUTCMonth(new_month);return new_date},moveYear:function(date,dir){return this.moveMonth(date,12*dir)},dateWithinRange:function(date){return date>=this.o.startDate&&date<=this.o.endDate},keydown:function(e){if(this.picker.is(":not(:visible)"))27==e.keyCode&&this.show();else{var dateChanged=!1,dir,day,month,newDate,newViewDate,element;switch(e.keyCode){case 27:this.hide(),e.preventDefault();break;case 37:case 39:if(!this.o.keyboardNavigation)break;dir=37==e.keyCode?-1:1,e.ctrlKey?(newDate=this.moveYear(this.date,dir),newViewDate=this.moveYear(this.viewDate,dir)):e.shiftKey?(newDate=this.moveMonth(this.date,dir),newViewDate=this.moveMonth(this.viewDate,dir)):((newDate=new Date(this.date)).setUTCDate(this.date.getUTCDate()+dir),(newViewDate=new Date(this.viewDate)).setUTCDate(this.viewDate.getUTCDate()+dir)),this.dateWithinRange(newDate)&&(this.date=newDate,this.viewDate=newViewDate,this.setValue(),this.update(),e.preventDefault(),dateChanged=!0);break;case 38:case 40:if(!this.o.keyboardNavigation)break;dir=38==e.keyCode?-1:1,e.ctrlKey?(newDate=this.moveYear(this.date,dir),newViewDate=this.moveYear(this.viewDate,dir)):e.shiftKey?(newDate=this.moveMonth(this.date,dir),newViewDate=this.moveMonth(this.viewDate,dir)):((newDate=new Date(this.date)).setUTCDate(this.date.getUTCDate()+7*dir),(newViewDate=new Date(this.viewDate)).setUTCDate(this.viewDate.getUTCDate()+7*dir)),this.dateWithinRange(newDate)&&(this.date=newDate,this.viewDate=newViewDate,this.setValue(),this.update(),e.preventDefault(),dateChanged=!0);break;case 13:this.hide(),e.preventDefault();break;case 9:this.hide()}if(dateChanged)this._trigger("changeDate"),this.isInput?element=this.element:this.component&&(element=this.element.find("input")),element&&element.change()}},showMode:function(dir){dir&&(this.viewMode=Math.max(this.o.minViewMode,Math.min(2,this.viewMode+dir))),this.picker.find(">div").hide().filter(".datepicker-"+DPGlobal.modes[this.viewMode].clsName).css("display","block"),this.updateNavArrows()}};var DateRangePicker=function(element,options){this.element=$(element),this.inputs=$.map(options.inputs,(function(i){return i.jquery?i[0]:i})),delete options.inputs,$(this.inputs).datepicker(options).bind("changeDate",$.proxy(this.dateUpdated,this)),this.pickers=$.map(this.inputs,(function(i){return $(i).data("datepicker")})),this.updateDates()};function opts_from_el(el,prefix){var data=$(el).data(),out={},inkey,replace=new RegExp("^"+prefix.toLowerCase()+"([A-Z])"),prefix=new RegExp("^"+prefix.toLowerCase());for(var key in data)prefix.test(key)&&(out[inkey=key.replace(replace,(function(_,a){return a.toLowerCase()}))]=data[key]);return out}function opts_from_locale(lang){var out={};if(dates[lang]||(lang=lang.split("-")[0],dates[lang])){var d=dates[lang];return $.each(locale_opts,(function(i,k){k in d&&(out[k]=d[k])})),out}}DateRangePicker.prototype={updateDates:function(){this.dates=$.map(this.pickers,(function(i){return i.date})),this.updateRanges()},updateRanges:function(){var range=$.map(this.dates,(function(d){return d.valueOf()}));$.each(this.pickers,(function(i,p){p.setRange(range)}))},dateUpdated:function(e){var dp,new_date=$(e.target).data("datepicker").getUTCDate(),i=$.inArray(e.target,this.inputs),l=this.inputs.length;if(-1!=i){if(new_date<this.dates[i])for(;i>=0&&new_date<this.dates[i];)this.pickers[i--].setUTCDate(new_date);else if(new_date>this.dates[i])for(;i<l&&new_date>this.dates[i];)this.pickers[i++].setUTCDate(new_date);this.updateDates()}},remove:function(){$.map(this.pickers,(function(p){p.remove()})),delete this.element.data().datepicker}};var old=$.fn.datepicker,datepicker=$.fn.datepicker=function(option){var args=Array.apply(null,arguments),internal_return,this_return;return args.shift(),this.each((function(){var $this=$(this),data=$this.data("datepicker"),options="object"==typeof option&&option;if(!data){var elopts=opts_from_el(this,"date"),xopts,locopts=opts_from_locale($.extend({},defaults,elopts,options).language),opts=$.extend({},defaults,locopts,elopts,options);if($this.is(".input-daterange")||opts.inputs){var ropts={inputs:opts.inputs||$this.find("input").toArray()};$this.data("datepicker",data=new DateRangePicker(this,$.extend(opts,ropts)))}else $this.data("datepicker",data=new Datepicker(this,opts))}if("string"==typeof option&&"function"==typeof data[option]&&void 0!==(internal_return=data[option].apply(data,args)))return!1})),void 0!==internal_return?internal_return:this},defaults=$.fn.datepicker.defaults={autoclose:!1,beforeShowDay:$.noop,calendarWeeks:!1,clearBtn:!1,daysOfWeekDisabled:[],endDate:1/0,forceParse:!0,format:"mm/dd/yyyy",keyboardNavigation:!0,language:"en",minViewMode:0,rtl:!1,startDate:-1/0,startView:0,todayBtn:!1,todayHighlight:!1,weekStart:0},locale_opts=$.fn.datepicker.locale_opts=["format","rtl","weekStart"];$.fn.datepicker.Constructor=Datepicker;var dates=$.fn.datepicker.dates={en:{days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"],daysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sun"],daysMin:["Su","Mo","Tu","We","Th","Fr","Sa","Su"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],monthsShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],today:"Today",clear:"Clear"}},DPGlobal={modes:[{clsName:"days",navFnc:"Month",navStep:1},{clsName:"months",navFnc:"FullYear",navStep:1},{clsName:"years",navFnc:"FullYear",navStep:10}],isLeapYear:function(year){return year%4==0&&year%100!=0||year%400==0},getDaysInMonth:function(year,month){return[31,DPGlobal.isLeapYear(year)?29:28,31,30,31,30,31,31,30,31,30,31][month]},validParts:/dd?|DD?|mm?|MM?|yy(?:yy)?/g,nonpunctuation:/[^ -\/:-@\[\u3400-\u9fff-`{-~\t\n\r]+/g,parseFormat:function(format){var separators=format.replace(this.validParts,"\0").split("\0"),parts=format.match(this.validParts);if(!separators||!separators.length||!parts||0===parts.length)throw new Error("Invalid date format.");return{separators:separators,parts:parts}},parseDate:function(date,format,language){if(date instanceof Date)return date;if("string"==typeof format&&(format=DPGlobal.parseFormat(format)),/^[\-+]\d+[dmwy]([\s,]+[\-+]\d+[dmwy])*$/.test(date)){var part_re=/([\-+]\d+)([dmwy])/,parts=date.match(/([\-+]\d+)([dmwy])/g),part,dir;date=new Date;for(var i=0;i<parts.length;i++)switch(part=part_re.exec(parts[i]),dir=parseInt(part[1]),part[2]){case"d":date.setUTCDate(date.getUTCDate()+dir);break;case"m":date=Datepicker.prototype.moveMonth.call(Datepicker.prototype,date,dir);break;case"w":date.setUTCDate(date.getUTCDate()+7*dir);break;case"y":date=Datepicker.prototype.moveYear.call(Datepicker.prototype,date,dir)}return UTCDate(date.getUTCFullYear(),date.getUTCMonth(),date.getUTCDate(),0,0,0)}var parts=date&&date.match(this.nonpunctuation)||[],date=new Date,parsed={},setters_order=["yyyy","yy","M","MM","m","mm","d","dd"],setters_map={yyyy:function(d,v){return d.setUTCFullYear(v)},yy:function(d,v){return d.setUTCFullYear(2e3+v)},m:function(d,v){for(v-=1;v<0;)v+=12;for(v%=12,d.setUTCMonth(v);d.getUTCMonth()!=v;)d.setUTCDate(d.getUTCDate()-1);return d},d:function(d,v){return d.setUTCDate(v)}},val,filtered,part;setters_map.M=setters_map.MM=setters_map.mm=setters_map.m,setters_map.dd=setters_map.d,date=UTCDate(date.getFullYear(),date.getMonth(),date.getDate(),0,0,0);var fparts=format.parts.slice();if(parts.length!=fparts.length&&(fparts=$(fparts).filter((function(i,p){return-1!==$.inArray(p,setters_order)})).toArray()),parts.length==fparts.length){for(var i=0,cnt=fparts.length;i<cnt;i++){if(val=parseInt(parts[i],10),part=fparts[i],isNaN(val))switch(part){case"MM":filtered=$(dates[language].months).filter((function(){var m=this.slice(0,parts[i].length),p;return m==parts[i].slice(0,m.length)})),val=$.inArray(filtered[0],dates[language].months)+1;break;case"M":filtered=$(dates[language].monthsShort).filter((function(){var m=this.slice(0,parts[i].length),p;return m==parts[i].slice(0,m.length)})),val=$.inArray(filtered[0],dates[language].monthsShort)+1}parsed[part]=val}for(var i=0,s;i<setters_order.length;i++)(s=setters_order[i])in parsed&&!isNaN(parsed[s])&&setters_map[s](date,parsed[s])}return date},formatDate:function(date,format,language){"string"==typeof format&&(format=DPGlobal.parseFormat(format));var val={d:date.getUTCDate(),D:dates[language].daysShort[date.getUTCDay()],DD:dates[language].days[date.getUTCDay()],m:date.getUTCMonth()+1,M:dates[language].monthsShort[date.getUTCMonth()],MM:dates[language].months[date.getUTCMonth()],yy:date.getUTCFullYear().toString().substring(2),yyyy:date.getUTCFullYear()};val.dd=(val.d<10?"0":"")+val.d,val.mm=(val.m<10?"0":"")+val.m;for(var date=[],seps=$.extend([],format.separators),i=0,cnt=format.parts.length;i<=cnt;i++)seps.length&&date.push(seps.shift()),date.push(val[format.parts[i]]);return date.join("")},headTemplate:'<thead><tr><th class="prev"><i class="icon-arrow-left"/></th><th colspan="5" class="datepicker-switch"></th><th class="next"><i class="icon-arrow-right"/></th></tr></thead>',contTemplate:'<tbody><tr><td colspan="7"></td></tr></tbody>',footTemplate:'<tfoot><tr><th colspan="7" class="today"></th></tr><tr><th colspan="7" class="clear"></th></tr></tfoot>'};DPGlobal.template='<div class="datepicker"><div class="datepicker-days"><table class=" table-condensed">'+DPGlobal.headTemplate+"<tbody></tbody>"+DPGlobal.footTemplate+'</table></div><div class="datepicker-months"><table class="table-condensed">'+DPGlobal.headTemplate+DPGlobal.contTemplate+DPGlobal.footTemplate+'</table></div><div class="datepicker-years"><table class="table-condensed">'+DPGlobal.headTemplate+DPGlobal.contTemplate+DPGlobal.footTemplate+"</table></div></div>",$.fn.datepicker.DPGlobal=DPGlobal,$.fn.datepicker.noConflict=function(){return $.fn.datepicker=old,this},$(document).on("focus.datepicker.data-api click.datepicker.data-api",'[data-provide="datepicker"]',(function(e){var $this=$(this);$this.data("datepicker")||(e.preventDefault(),datepicker.call($this,"show"))})),$((function(){datepicker.call($('[data-provide="datepicker-inline"]'))}))}(window.jQuery),function($){"use strict";$.fn.bdatepicker=$.fn.datepicker.noConflict(),$.fn.datepicker||($.fn.datepicker=$.fn.bdatepicker);var Date=function(options){this.init("date",options,Date.defaults),this.initPicker(options,Date.defaults)};$.fn.editableutils.inherit(Date,$.fn.editabletypes.abstractinput),$.extend(Date.prototype,{initPicker:function(options,defaults){this.options.viewformat||(this.options.viewformat=this.options.format),options.datepicker=$.fn.editableutils.tryParseJson(options.datepicker,!0),this.options.datepicker=$.extend({},defaults.datepicker,options.datepicker,{format:this.options.viewformat}),this.options.datepicker.language=this.options.datepicker.language||"en",this.dpg=$.fn.bdatepicker.DPGlobal,this.parsedFormat=this.dpg.parseFormat(this.options.format),this.parsedViewFormat=this.dpg.parseFormat(this.options.viewformat)},render:function(){this.$input.bdatepicker(this.options.datepicker),this.options.clear&&(this.$clear=$('<a href="#"></a>').html(this.options.clear).click($.proxy((function(e){e.preventDefault(),e.stopPropagation(),this.clear()}),this)),this.$tpl.parent().append($('<div class="editable-clear">').append(this.$clear)))},value2html:function(value,element){var text=value?this.dpg.formatDate(value,this.parsedViewFormat,this.options.datepicker.language):"";Date.superclass.value2html.call(this,text,element)},html2value:function(html){return this.parseDate(html,this.parsedViewFormat)},value2str:function(value){return value?this.dpg.formatDate(value,this.parsedFormat,this.options.datepicker.language):""},str2value:function(str){return this.parseDate(str,this.parsedFormat)},value2submit:function(value){return this.value2str(value)},value2input:function(value){this.$input.bdatepicker("update",value)},input2value:function(){return this.$input.data("datepicker").date},activate:function(){},clear:function(){this.$input.data("datepicker").date=null,this.$input.find(".active").removeClass("active"),this.options.showbuttons||this.$input.closest("form").submit()},autosubmit:function(){this.$input.on("mouseup",".day",(function(e){if(!$(e.currentTarget).is(".old")&&!$(e.currentTarget).is(".new")){var $form=$(this).closest("form");setTimeout((function(){$form.submit()}),200)}}))},parseDate:function(str,format){var date=null,formattedBack;return str&&(date=this.dpg.parseDate(str,format,this.options.datepicker.language),"string"==typeof str&&str!==(formattedBack=this.dpg.formatDate(date,format,this.options.datepicker.language))&&(date=null)),date}}),Date.defaults=$.extend({},$.fn.editabletypes.abstractinput.defaults,{tpl:'<div class="editable-date well"></div>',inputclass:null,format:"yyyy-mm-dd",viewformat:null,datepicker:{weekStart:0,startView:0,minViewMode:0,autoclose:!1},clear:"&times; clear"}),$.fn.editabletypes.date=Date}(window.jQuery),function($){"use strict";var DateField=function(options){this.init("datefield",options,DateField.defaults),this.initPicker(options,DateField.defaults)};$.fn.editableutils.inherit(DateField,$.fn.editabletypes.date),$.extend(DateField.prototype,{render:function(){this.$input=this.$tpl.find("input"),this.setClass(),this.setAttr("placeholder"),this.$input.bdatepicker(this.options.datepicker),this.$input.off("focus keydown"),this.$input.keyup($.proxy((function(){this.$tpl.removeData("date"),this.$tpl.bdatepicker("update")}),this))},value2input:function(value){this.$input.val(value?this.dpg.formatDate(value,this.parsedViewFormat,this.options.datepicker.language):""),this.$tpl.bdatepicker("update")},input2value:function(){return this.html2value(this.$input.val())},activate:function(){$.fn.editabletypes.text.prototype.activate.call(this)},autosubmit:function(){}}),DateField.defaults=$.extend({},$.fn.editabletypes.date.defaults,{tpl:'<div class="input-append date"><input type="text"/><span class="add-on"><i class="icon-th"></i></span></div>',inputclass:"input-small",datepicker:{weekStart:0,startView:0,minViewMode:0,autoclose:!0}}),$.fn.editabletypes.datefield=DateField}(window.jQuery),function($){"use strict";var DateTime=function(options){this.init("datetime",options,DateTime.defaults),this.initPicker(options,DateTime.defaults)};$.fn.editableutils.inherit(DateTime,$.fn.editabletypes.abstractinput),$.extend(DateTime.prototype,{initPicker:function(options,defaults){this.options.viewformat||(this.options.viewformat=this.options.format),options.datetimepicker=$.fn.editableutils.tryParseJson(options.datetimepicker,!0),this.options.datetimepicker=$.extend({},defaults.datetimepicker,options.datetimepicker,{format:this.options.viewformat}),this.options.datetimepicker.language=this.options.datetimepicker.language||"en",this.dpg=$.fn.datetimepicker.DPGlobal,this.parsedFormat=this.dpg.parseFormat(this.options.format,this.options.formatType),this.parsedViewFormat=this.dpg.parseFormat(this.options.viewformat,this.options.formatType)},render:function(){this.$input.datetimepicker(this.options.datetimepicker),this.$input.on("changeMode",(function(e){var f=$(this).closest("form").parent();setTimeout((function(){f.triggerHandler("resize")}),0)})),this.options.clear&&(this.$clear=$('<a href="#"></a>').html(this.options.clear).click($.proxy((function(e){e.preventDefault(),e.stopPropagation(),this.clear()}),this)),this.$tpl.parent().append($('<div class="editable-clear">').append(this.$clear)))},value2html:function(value,element){var text=value?this.dpg.formatDate(this.toUTC(value),this.parsedViewFormat,this.options.datetimepicker.language,this.options.formatType):"";if(!element)return text;DateTime.superclass.value2html.call(this,text,element)},html2value:function(html){var value=this.parseDate(html,this.parsedViewFormat);return value?this.fromUTC(value):null},value2str:function(value){return value?this.dpg.formatDate(this.toUTC(value),this.parsedFormat,this.options.datetimepicker.language,this.options.formatType):""},str2value:function(str){var value=this.parseDate(str,this.parsedFormat);return value?this.fromUTC(value):null},value2submit:function(value){return this.value2str(value)},value2input:function(value){value&&this.$input.data("datetimepicker").setDate(value)},input2value:function(){var dt=this.$input.data("datetimepicker");return dt.date?dt.getDate():null},activate:function(){},clear:function(){this.$input.data("datetimepicker").date=null,this.$input.find(".active").removeClass("active"),this.options.showbuttons||this.$input.closest("form").submit()},autosubmit:function(){this.$input.on("mouseup",".minute",(function(e){var $form=$(this).closest("form");setTimeout((function(){$form.submit()}),200)}))},toUTC:function(value){return value?new Date(value.valueOf()-6e4*value.getTimezoneOffset()):value},fromUTC:function(value){return value?new Date(value.valueOf()+6e4*value.getTimezoneOffset()):value},parseDate:function(str,format){var date=null,formattedBack;return str&&(date=this.dpg.parseDate(str,format,this.options.datetimepicker.language,this.options.formatType),"string"==typeof str&&str!==(formattedBack=this.dpg.formatDate(date,format,this.options.datetimepicker.language,this.options.formatType))&&(date=null)),date}}),DateTime.defaults=$.extend({},$.fn.editabletypes.abstractinput.defaults,{tpl:'<div class="editable-date well"></div>',inputclass:null,format:"yyyy-mm-dd hh:ii",formatType:"standard",viewformat:null,datetimepicker:{todayHighlight:!1,autoclose:!1},clear:"&times; clear"}),$.fn.editabletypes.datetime=DateTime}(window.jQuery),function($){"use strict";var DateTimeField=function(options){this.init("datetimefield",options,DateTimeField.defaults),this.initPicker(options,DateTimeField.defaults)};$.fn.editableutils.inherit(DateTimeField,$.fn.editabletypes.datetime),$.extend(DateTimeField.prototype,{render:function(){this.$input=this.$tpl.find("input"),this.setClass(),this.setAttr("placeholder"),this.$tpl.datetimepicker(this.options.datetimepicker),this.$input.off("focus keydown"),this.$input.keyup($.proxy((function(){this.$tpl.removeData("date"),this.$tpl.datetimepicker("update")}),this))},value2input:function(value){this.$input.val(this.value2html(value)),this.$tpl.datetimepicker("update")},input2value:function(){return this.html2value(this.$input.val())},activate:function(){$.fn.editabletypes.text.prototype.activate.call(this)},autosubmit:function(){}}),DateTimeField.defaults=$.extend({},$.fn.editabletypes.datetime.defaults,{tpl:'<div class="input-append date"><input type="text"/><span class="add-on"><i class="icon-th"></i></span></div>',inputclass:"input-medium",datetimepicker:{todayHighlight:!1,autoclose:!0}}),$.fn.editabletypes.datetimefield=DateTimeField}(window.jQuery);